/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.isdn;

import ibm.nways.jdm.I18NGiblets;
import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.JdmServerImpl;
import ibm.nways.jdm.StatusType;
import ibm.nways.jdm.modelgen.StatusMapper;
import ibm.nways.jdm.modelgen.StatusModelInfo;
import ibm.nways.jdm.modelgen.TableStatusNamer;
import java.util.Locale;

public class ActionIsdn
implements StatusMapper,
TableStatusNamer {
    private static String bundleName = "ibm.nways.isdn.Resources";
    private static String enumBundle = "ibm.nways.isdn.eui.EnumeratedResources";
    private boolean loggingOn = false;

    public ActionIsdn() {
        String string = JdmServerImpl.getProperty("startLogging");
        if (string != null && string.equals("yes")) {
            this.loggingOn = true;
        }
    }

    public void calculateStatus(StatusModelInfo statusModelInfo, StatusModelInfo statusModelInfo2) {
        try {
            Object[] objectArray = statusModelInfo.getIndexes();
            if (this.loggingOn) {
                System.out.println("ActionIsdn");
                System.out.println("Interface = " + objectArray[0]);
                System.out.println("IsdnLapdOperStatus = " + statusModelInfo.get("Panel.IsdnLapdOperStatus"));
            }
            StatusAndExplain statusAndExplain = this.evaluateStatus((Integer)statusModelInfo.get("Panel.IsdnLapdOperStatus"), objectArray);
            statusModelInfo.setStatusType(statusAndExplain.statType, statusAndExplain.explain, true);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public I18NString nameThatObject(StatusModelInfo statusModelInfo) {
        Object[] objectArray = statusModelInfo.getIndexes();
        I18NMsgFormat i18NMsgFormat = new I18NMsgFormat(bundleName, "STATUS_NAME", objectArray);
        return i18NMsgFormat;
    }

    public I18NString nameThatTableObject(StatusModelInfo statusModelInfo) {
        I18NString i18NString = new I18NString(bundleName, "STATUS_TABLE_NAME");
        return i18NString;
    }

    private StatusAndExplain evaluateStatus(int n, Object[] objectArray) {
        StatusAndExplain statusAndExplain = new StatusAndExplain();
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = new I18NMsgFormat(bundleName, "LAPD_CHANNEL", objectArray);
        switch (n) {
            case 3: {
                statusAndExplain.statType = StatusType.NORMAL;
                objectArray2[1] = new I18NString(enumBundle, "ibm.nways.isdn.model.IsdnLapdModel.Panel.IsdnLapdOperStatus.l2Active");
                break;
            }
            case 2: {
                statusAndExplain.statType = StatusType.MARGINAL;
                objectArray2[1] = new I18NString(enumBundle, "ibm.nways.isdn.model.IsdnLapdModel.Panel.IsdnLapdOperStatus.l1Active");
                break;
            }
            case 1: {
                statusAndExplain.statType = StatusType.CRITICAL;
                objectArray2[1] = new I18NString(enumBundle, "ibm.nways.isdn.model.IsdnLapdModel.Panel.IsdnLapdOperStatus.inactive");
                break;
            }
            default: {
                statusAndExplain.statType = StatusType.UNKNOWN;
                objectArray2[1] = new I18NString(bundleName, "UNEXPECTED");
            }
        }
        statusAndExplain.explain = new I18NGiblets(bundleName, "STATUSMESSAGE", objectArray2);
        if (this.loggingOn) {
            System.out.println("ret.statType = " + statusAndExplain.statType);
            System.out.println("ret.explain = " + statusAndExplain.explain.getTranslation(Locale.getDefault()));
        }
        return statusAndExplain;
    }

    private class StatusAndExplain {
        StatusType statType;
        I18NGiblets explain;

        StatusAndExplain() {
            ActionIsdn.this = ActionIsdn.this;
        }
    }
}

